#version 460
layout(triangles, equal_spacing, ccw) in;

  
layout(packed, binding=0) buffer model_list {
        mat4 models[];
};
layout(packed, binding=1) buffer up_list {
        vec4 ups[];
};
layout(packed, binding=2) buffer forward_list {
        vec3 forwards[];
};
layout(packed, binding=3) buffer radii_list {
        float radii[];
};
layout(packed, binding=4) buffer explode_list {
	float explode_factor[];
};

uniform mat4 vp;
in vec4 tcs_colorout[];
in int vs_id_tcs[];
out vec4 tes_colorout;
out vec4 normal;
out mat4 mvp;

vec4 n4(vec4 p){
	vec3 offset = p.xyz;// - cntr[0].xyz;
	return vec4(normalize(offset) * radii[vs_id_tcs[0]], 1);
}

void main(){
	vec4 p = 
			gl_TessCoord.x * gl_in[0].gl_Position +
			gl_TessCoord.y * gl_in[1].gl_Position +
			gl_TessCoord.z * gl_in[2].gl_Position;

	float ef = ups[vs_id_tcs[0]].a;
	if(ef > 0)
		normal = vec4(0, 0, 0, 0);
	else
		normal = -ef * vec4(normalize(p.xyz), 0);

	mvp = vp * models[vs_id_tcs[0]];	

	gl_Position = n4(p);

	tes_colorout = 
			gl_TessCoord.x * tcs_colorout[0] +
			gl_TessCoord.y * tcs_colorout[1] +
			gl_TessCoord.z * tcs_colorout[2];
}

