#version 460

  
layout(packed, binding=0) buffer model_list {
        mat4 models[];
};
layout(packed, binding=1) buffer up_list {
        vec4 ups[];
};
layout(packed, binding=2) buffer forward_list {
        vec3 forwards[];
};
layout(packed, binding=3) buffer radii_list {
        float radii[];
};


in vec3 in_vertex;
uniform mat4 vp;
out vec4 v_colorout;
out int vs_id;

void main(void) {
	vec3 sideways = normalize(cross(ups[gl_InstanceID].xyz, forwards[gl_InstanceID]));
	vec3 pos =  in_vertex.x * sideways +
	  in_vertex.y * forwards[gl_InstanceID] +
	  in_vertex.z * ups[gl_InstanceID].xyz; 

	gl_Position = vec4(pos, 1.0);
	v_colorout = vec4(in_vertex, 1.0);
	if(v_colorout.r < 0)
		v_colorout.r = 0;
	if(v_colorout.g < 0)
		v_colorout.g = 0;
	if(v_colorout.b < 0)
		v_colorout.b = 0;
	vs_id = gl_InstanceID;

}
