#include "game.h"
#include "vehicle.h"

void flying_carpet::vehicle_move() {
	glm::vec3 step_to_point = locations[0];
	if(player_key_status.forward){
		step_to_point += 0.5f * glm::vec3(sinf(player_heading), sinf(player_elevation), cosf(player_heading));
	}
	if(player_key_status.backward){
		step_to_point += 0.5f * glm::vec3(-sinf(player_heading), -sinf(player_elevation), -cosf(player_heading));
	}
	if(player_key_status.left){
		step_to_point += 0.5f * glm::vec3(sinf(player_heading + M_PI/2), 0, cosf(player_heading + M_PI/2));
	}
	if(player_key_status.right){
		step_to_point += 0.5f * glm::vec3(-sinf(player_heading + M_PI/2), 0, -cosf(player_heading + M_PI/2));
	}
	locations[vehicle_index] = step_to_point;
	player_position = glm::vec3(step_to_point.x, step_to_point.y + 3.0f, step_to_point.z);
	ups[0] = glm::rotate(glm::mat4(1.0f), player_heading, glm::vec3(0, 1, 0)) * glm::vec4(0, 0, 1, 1);
}

void flying_carpet::activate(size_t index) {
	current_vehicle = this;
	vehicle_index = index;
	player_position = locations[0] + glm::vec3(0, 3, 0);
}	
