#include<stdlib.h>
#include<unistd.h>
#include<ctype.h>
#include<string.h>

char encrypt(unsigned char input, int key){
	if(!isalpha(input))
		return input;
	char max = 'z';
	if(isupper(input))
		max = 'Z';
	input += key;
	if(input > max)
		input -= 26;
	return input;
}

int main(int argc, char **argv){
	int key = 13;
	char strip_punctuation = 0;
	if(argc > 1){
		if(!strcmp(argv[1], "-p")) // The argument is -p
			strip_punctuation = 1;
		else
			key = atoi(argv[1]);
		if(argc > 2){
			if(!strcmp(argv[2], "-p")) // The argument is -p
				strip_punctuation = 1;
			else
				key = atoi(argv[2]);
		}
	}
	
	char buffer[1024];
	while(1){
		ssize_t readlen = read(0, buffer, 1024);
		if(readlen < 1)
			break;
		if(strip_punctuation){
			int j = 0;
			for(int i = 0; i < readlen; i++){
				if(isalpha(buffer[i]))
				  	buffer[j++] = encrypt(buffer[i], key);
			}
			write(1, buffer, j);	
		} else {
			for(int i = 0; i < readlen; i++)
				  	buffer[i] = encrypt(buffer[i], key);
			write(1, buffer, readlen);	
		}
	}

	return 0;
}
