#include<fcntl.h>
#include<stdio.h>
#include<stdlib.h>
#include<sys/stat.h>
#include<unistd.h>
#include<ctype.h>

/* If delimiter is 0, this will split on whitespace characters 
 * Note:  This will modify the original string!  */
char ** split_string(char* start, char delimiter){
	size_t allocated_places = 100;
	char ** splits = (char**)calloc(sizeof(char*), 100);
	int sp = 0;
	splits[0] = start;
	for(int i = 0; start[i] != 0; i++){
		if( (delimiter == 0)? isspace(start[i]):(start[i] == delimiter) ){
			start[i] = 0;
			if( (delimiter == 0)? isspace(start[i+1]):(start[i+1] == delimiter) )
				continue;
			splits[sp] = 0;
			splits[sp++] = start + i+1;
			if(allocated_places < sp+2){
				allocated_places += 100;
				splits = (char**)realloc(splits, sizeof(char*) * allocated_places);
			}
		}
	}
	return splits;
}

void print_array(char ** split_result){
	printf("[");
	for(int i = 0; split_result[i]; i++)
		printf("%s, ", split_result[i]);
	printf("\b\b]\n");
}

int main(){
	char message[] = "The tulips mowed by tractor     nobody likes that	but it's needed";
	char **split_result = split_string(message, 0);
	print_array(split_result);
	free(split_result);

	puts("Beginning long test!");
	int fd = open("/tmp/poem", O_RDONLY);
	char poem[20000];
	size_t readlen = read(fd, poem, 20000);
	poem[readlen] = 0;
	split_result = split_string(poem, 0);
//	print_array(split_result);
	free(split_result);
	return 0;
}
