#include<unistd.h>
#include<string.h>
#include<stdio.h>


#define BUFSIZE 1024*1024

// newline -r e -b
// -r means replacement character
// -b means to run backwards, replacing the specified character with a newline

int main(int argc, char ** argv){
	char replacement_character = ' ';
	char backwards = 0;

	// What if they run:
	// newline -br _

	for(int i = 1; i < argc; i++){
		if(!strcmp("-r", argv[i])){
			// specified like "-rw"
			// argv would look like this:  ["newline", "-rw"] (w is the replacement character)
			// argv[i] will be "-rw"
			if(argv[i][2] != 0)
				replacement_character = argv[i][2];
			// specified like "newline -r w"
			// argv would look like this:  ["newline", "-r", "w"]
			// argv[i] will be "-r"
			// argv[i + 1] will be "w"
			else
				replacement_character = argv[i+1][0];
		}
		if(!strcmp("-b", argv[i]))
			backwards = 1;
		if(!strcmp("--help", argv[i])){
			printf("Usage:  %s [-b] [-r replacement_character] \n ");
			return 0;
		}
		if(!strcmp("--version", argv[i])){
			printf("1.0\n");
			return 0;
		}
	}

	// Ways to read:
	// 	scanf and read strings
	// 	Move to c++ and use cin
	// 	getline (or c++ getline
	// 	read (unix standard)
	char buffer[BUFSIZE];
	// File descriptors:
	// 	0 is standard in
	// 	1 is standard out
	// 	2 is standard error
	ssize_t readlen;
	while(1){
		readlen = read(0, buffer, BUFSIZE-1);
		if(readlen <= 0)
			break;
		buffer[readlen] = 0;
	
		if(!backwards){
			for(int i = 0; i < readlen; i++)
				if(buffer[i] == '\n')
					buffer[i] = replacement_character;
		} else {
			for(int i = 0; i < readlen; i++)
				if(buffer[i] == replacement_character)
					buffer[i] = '\n';
		}

		write(1, buffer, readlen);
	}
	write(1, "\n", 1);

	return 0;
}
