#include<argp.h>
#include<stdio.h>
#include<stdlib.h>
#include "scolor.h"

struct arguments {
	int nfacts;
	char print_count, green;
};	
struct arguments arguments = {1, 0, 0};

const char *argp_program_version = "4.9.2020";
static char doc[] = "Program to print facts about goats";
static char args_doc[] = "";
static struct argp_option options[] = {
	{"count", 'c', 0, 0, "Show how many goat facts we have"},	
	{"number", 'n', "facts", 0, "Number of facts to display"},
	{"green", 'g', 0, 0, "Print facts in green"},
	{0}
};

static error_t parse_opt(int key, char *arg, struct argp_state *state){
	switch(key){
		case 'c':
			arguments.print_count = 1;
			break;
		case 'n':
			arguments.nfacts = atoi(arg);
			break;
		case 'g':
			arguments.green = 1;
			break;
		default:
			return ARGP_ERR_UNKNOWN;	
	}
	return 0;
}

static struct argp argp = {options, parse_opt, args_doc, doc};

char *facts[] = {"Goats like the leaf from alfalfa, and try to waste all the stems", "Goats like to eat raspberry leaves", "A goat bit my pants last night", "Goat normally have horns, and all mine have horns."};
int factcount = 4;

int main(int argc, char ** argv){
	argp_parse(&argp, argc, argv, 0, 0, &arguments);

	if(arguments.print_count){
		printf("We have %d facts\n", factcount);
		return 0;
	}

	if(arguments.nfacts > factcount)
		arguments.nfacts = factcount;
	for(int i = 0; i < arguments.nfacts; i++){
		if(arguments.green)
			printf(GREEN("%s\n"), facts[i]);
		else
			puts(facts[i]);
	}
	return 0;
}

