#include<stdio.h>
#include<unistd.h>
#include<string.h>
#include<fcntl.h>
#include<termios.h>

void clearline(){
	write(1, "                    \b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b", 40);
}

char last[1024] = "";

void run_command(const char *cmdbuffer){
	printf("Running Command:  %s\n", cmdbuffer);
}

void main(){

	struct termios settings;
	tcgetattr(0, &settings);
	settings.c_cc[VMIN] = 1;
	settings.c_lflag ^= ICANON;
	settings.c_lflag ^= ECHO;
	tcsetattr(0, TCSANOW, &settings);

	char seq = 0;
	char cmdbuffer[1024];
	size_t cmdbufend = 0;
	while(1){
		unsigned char c;
		read(0, &c, 1);
//		printf("Read code:  %d\n", c);
		if( (c == 27 && seq == 0) || (c == 91 && seq == 1) )
			seq++;
		else if(c == 65 && seq == 2){
			seq = 0;
			cmdbufend = strlen(last);
			strcpy(cmdbuffer, last);
			write(1, "\r", 1);
			write(1, cmdbuffer, cmdbufend);
			clearline();
		} else if(c == 127){
			write(1, "\b \b", 3);
			cmdbufend--;
		} else if(c == '\n'){
			cmdbuffer[cmdbufend] = 0;
			write(1, "\n", 1);
			run_command(cmdbuffer);
			strncpy(last, cmdbuffer, cmdbufend+1);
			cmdbufend = 0;
		}
		else {
			write(1, &c, 1);
			cmdbuffer[cmdbufend++] = c;
		}
		
	}
}
