#include<stdio.h>

void function_one(int our_parameter){
	printf("Function one received parameter %d\n", our_parameter);
}

float function_two(int our_parameter){
	printf("Function two received parameter %d\n", our_parameter);
	return 3.14159;
}

int cube(int x){
	return x*x*x;
}
int square(int x){
	return x*x;
}

int (*return_function(int choice))(int){
	if(choice == 1)
		return cube;
	else
		return square;
}

void run_other(int (*other_function)(int)){
	printf("other_function returned %d\n", other_function(16));
}

int main(){

	void (*the_name)(int);
	the_name = function_one;
	the_name(5);
	// We can avoid the warning (error in C++) with a static cast
	the_name = (void (*)(int))function_two;
	// A static cast:  x is not an int, but we want to treat it as one:
	// int y = (int)x;
	// Usually we try to avoid lines like the following:
	float result = ((float(*)(int))the_name)(10);
	printf("result = %f\n", result);

	run_other(cube);
	run_other(return_function(2));
	int resulti = return_function(1)(5);
	printf("result = %d\n", resulti);
	return 0;
}


