#include<stdio.h>
#include<stdlib.h>

void populate_table(int **table, size_t width, size_t height){
	for(int row = 0; row < height; row++)
		for(int col = 0; col < width; col++)
			table[row][col] = (row + 1) * (col + 1);
}

void print_table(int **table, size_t width, size_t height){
	for(int row = 0; row < height; row++){
		for(int col = 0; col < width; col++)
			printf("%3d ", table[row][col]);
		printf("\n");
	}
}

#define ROWS 24
#define COLS 16


int main(){
	int *table[ROWS];
	for(int i = 0; i < ROWS; i++)
		table[i] = malloc(COLS * sizeof(int));	

	populate_table(table, COLS, ROWS);
	print_table(table+12, COLS, 12);

	puts("****");
	print_table(table, COLS, ROWS);
	puts("****");

	// Print last 8 columns
	for(int i = 0; i < ROWS; i++)
		table[i] += 8;
	print_table(table+12, 8, 12);

	for(int i = 0; i < ROWS; i++)
		table[i] -= 8;
	print_table(table, 8, 12);

	for(int row = 0; row < ROWS; row++)
		free(table[row]);
	return 0;
}
