#include<unistd.h>
#include<stdlib.h>
#include<stdio.h>
#include<string.h>

int main(int argc, char ** argv){
	if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 'h'){
		printf("Usage Info:  %s [-rb] [PATTERN]\n", argv[0]);
		return 0;
	}

	char *pattern = 0;
	char option_r = 0, option_b = 0;
	for(int i = 1; i < argc; i++){
		if(argv[i][0] == '-'){
			switch(argv[i][1]){
				case 'r':
					option_r = 1;
					break;
				case 'b':
					option_b = 1;
					break;
				default:
					printf("No such option %s\n", argv[i]);
					return 1;
			}
		} else 
			pattern = argv[i];
	}

	char buffer[1025];
	while(1){
		size_t readlen = read(0, buffer, 1024);
		if(readlen == 0)
			break;
		buffer[readlen] = 0;

		// No options
		if(argc == 1){
			for(size_t i = 0; i < readlen; i++){
				if(buffer[i] == '\n')
					buffer[i] = ' ';
			}
			write(1, buffer, readlen);
		}

		if(pattern && option_b){
			size_t plen = strlen(pattern);
			char *current_spot = buffer;
			while(1){
				char *match = strstr(current_spot, pattern);
				if(!match)
					break;
				size_t until_match = match - current_spot;
				write(1, current_spot, until_match);
				write(1, "\n", 1);
				current_spot = current_spot + until_match + plen;
			}
			write(1, current_spot, strlen(current_spot));
		}

		if(pattern && !option_b){
			for(size_t i = 0; i < readlen; i++){
				if(buffer[i] == '\n')
					write(1, pattern, strlen(pattern));
				else
					write(1, buffer + i, 1);
			}
		}

	}

	return 0;
}


