/*
 * Start with this file for project 2
 * Remember to include -l readline when you build it
 * Like this:
 * gcc shell.c -l readline [-o filename]
 */

#include<stdio.h>
#include<unistd.h>
#include<string.h>
#include<ctype.h>
#include<sys/wait.h>
#include<stdlib.h>
#include<readline/readline.h>
#include<readline/history.h>

#define MAX_CMDLEN 4196
/*
 * run_command:  Run the command specified in the first parameter
 * Return value is the process ID of the command that has been run
 * Parameters:
 * 	1.  Command to run
 * 	2.  File descriptor for command input, usually 0
 * 	3.  File descriptor for command output, usually 1
 * 	4.  File descriptor to close in the child process (0 if none)
 */
pid_t run_command(char*, int, int, int);

char *strip_whitespace(char *str){
	char *actual_start = str;
	while(isspace(*actual_start)) 
		actual_start++;	
	char *end = str + strlen(str) - 1;
	while(isspace(*end)){
		*end = 0;
		end--;
	}
	return actual_start;
}

char* find_symbol(char *str, char symbol){
	char inquote = 0;
	for(int i = 0; str[i]; i++){
		if(str[i] == '"')
			inquote = !inquote;
		if(!inquote && str[i] == symbol)
			return str+i;
	}
	return 0;
}

void handle_pipes(char *command){
	char *first_pipe = find_symbol(command, '|');
	if(!first_pipe){
		run_command(command, 0, 1, 0);
		int exit_status;
		wait(&exit_status);
		printf("Command %s exited with status %d\n", command, exit_status);
		return;
	}
	// If there are pipes, we do all this
	int commands = 0;
	int input_source = 0;
	int output_source = 1;
	char *current_command = command;
	char *next_command = 0;
	while(next_command = find_symbol(current_command, '|')){
		*next_command = 0;
		next_command++;
		int pipe_ends[2];
		pipe(pipe_ends);
		output_source = pipe_ends[1];	
		run_command(current_command, input_source, output_source, 0);
		close(output_source);
		commands++;
		if(input_source)
			close(input_source);
		input_source = pipe_ends[0];	
		current_command = next_command;
	}
	run_command(current_command, input_source, 1, output_source); // Close output_source, not input_source
	close(output_source);
	commands++;
	if(input_source)
		close(input_source);

	for(int i = 0; i < commands; i++)
		wait(0);
}
/*
 * What if command contains a pipe?  Like this:  one | two | three
 * We'll have to find the pipe symbols in the string, so we can have each command as a separate string
 * We'll need one pipe for every pipe symbol we find!
 * We'll need to call fork() once for every program we will run
 */
pid_t run_command(char *command, int in_fd, int out_fd, int close_fd){
	char* actual_command = strip_whitespace(command);
	printf("Running command:  \"%s\" (< %d > %d\n", actual_command, in_fd, out_fd);
	char *argv[10];
	argv[0] = actual_command;
	int next_arg = 1;
	size_t string_length = strlen(actual_command);
	char inquotes = 0;
	for(int i = 0; i < string_length; i++){
		if(actual_command[i] == '"'){
			inquotes = !inquotes;
		}
		if(!inquotes && actual_command[i] == ' '){
			argv[next_arg] = actual_command + i + 1; // Same as &actual_command[i+1]
			actual_command[i] = 0;
			if(argv[next_arg][0] == ' ') // The space eater is actually needed
				continue;
			next_arg++;
		}
	}
	argv[next_arg] = 0;
	// argv post processing!
	for(int i = 0; argv[i]; i++){
		argv[i] = strip_whitespace(argv[i]);
		if(argv[i][0] == '"')
			argv[i]++;
		if(argv[i][strlen(argv[i])-1] == '"')
			argv[i][strlen(argv[i])-1] = 0;
	}


	pid_t pid = fork();
	if(pid){ // We're the parent
		return pid;
	} else { // We're the child
		if(close_fd)
			close(close_fd);
		dup2(in_fd, 0);
		dup2(out_fd, 1);
		// 2> and 2>> will require standard error redirection
		// It's file descriptor 2, works like 0 and 1 above
		execvp(actual_command, argv);	
	}	
	return 0;
}

int main(){
	char prompt[256];
	while(1){
		getcwd(prompt, 256);
		sprintf(prompt + strlen(prompt), " >> ");
		char* command = readline(prompt);
		if(command == 0)
			break;
		add_history(command);
		if(!strncmp(command, "cd", 2) && (strlen(command) == 2 || command[2] == ' ')){
			const char *directory = "~";
			if(strlen(command) > 2)
				directory = strip_whitespace(command + 3);
			chdir(directory);
		} else {
			handle_pipes(command);
		}
		free(command);
	}
	write(2, "\n", 1);
}
