#pragma once
class door : public loaded_object, public block_object {
	public:
		/* States for this door:
		 *		closed: 0 
		 *		closing:  1
		 *		opening:  2
		 *		open: 3
		 */
		std::vector<int> states;
		std::vector<float> open_angles;
		door(const char* of, const char* tf, glm::vec3 s) : loaded_object(of, tf, s) {
			collision_check = true;
		}
		void open(size_t index);
		void close(size_t index);
		void activate(size_t index) override;
		void move(int elapsed_time) override;
		std::vector<glm::mat4> create_models() override;
		ssize_t collision_index(glm::vec3 position, float distance);
		void add_door(glm::vec3 location);
		bool is_on_idx(glm::vec3 position, size_t index, float height);
};

